@echo off
SETLOCAL ENABLEDELAYEDEXPANSION

REM --- Interactive SQL Connection String Generator ---
REM This script is fully self-contained and uses Windows Authentication.
REM It finds SQL instances, lets the user choose a database, and generates the final connection string.

echo ==========================================================
echo  SQL Server Connection String Generator
echo ==========================================================
echo.
echo This script will find local SQL Server instances and help you create
echo the correct connection string for your application.
echo.

REM --- Step 1: Discover SQL Server Instances from Services ---
echo Searching for local SQL Server instances...
FOR /F "tokens=2" %%a IN ('sc query state^= all ^| find "SERVICE_NAME" ^| find "MSSQL$"') DO (
    SET "INSTANCE_NAME=%%a"
    SET "INSTANCE_NAME=!INSTANCE_NAME:MSSQL$=!"
    CALL :PROCESS_INSTANCE "!COMPUTERNAME!\!INSTANCE_NAME!"
)
FOR /F "tokens=2" %%a IN ('sc query state^= all ^| find "SERVICE_NAME" ^| find "MSSQLSERVER"') DO (
    CALL :PROCESS_INSTANCE "!COMPUTERNAME!"
)

echo.
echo All found SQL instances have been processed.
echo.
pause
GOTO :EOF


:PROCESS_INSTANCE
SET "SERVER_INSTANCE=%~1"
echo.
echo ----------------------------------------------------------
echo [+] Found SQL Instance: %SERVER_INSTANCE%
echo ----------------------------------------------------------
echo.

REM --- Step 2: Check Connection and Discover Encryption ---
echo Discovering connection properties...
SET "ENCRYPT_VALUE=False"
SET "TRUST_CERT_VALUE=False"
sqlcmd -S "%SERVER_INSTANCE%" -E -Q "SET NOCOUNT ON; SELECT TOP 1 [encrypt_option] FROM sys.dm_exec_connections WHERE session_id = @@SPID" -W -h-1 > "%TEMP%\encrypt_check.tmp" 2>NUL

IF %ERRORLEVEL% NEQ 0 (
    echo [ERROR] Could not connect to '%SERVER_INSTANCE%' using the current Windows user.
    echo Please ensure the user has permissions to access the SQL Server.
    GOTO :EOF
)

FOR /F %%e IN ('type "%TEMP%\encrypt_check.tmp"') DO (
    IF /I "%%e"=="TRUE" (
        SET "ENCRYPT_VALUE=True"
        SET "TRUST_CERT_VALUE=True"
    )
)
DEL "%TEMP%\encrypt_check.tmp" > NUL 2>NUL
echo    - Encryption in use: !ENCRYPT_VALUE!
echo.


REM --- Step 3: List Databases for User Selection ---
echo Please choose a database from the list below:
SET "DB_COUNT=0"
FOR /F "usebackq delims=" %%d IN (`sqlcmd -S "%SERVER_INSTANCE%" -E -Q "SET NOCOUNT ON; SELECT name FROM sys.databases WHERE database_id > 4;" -W -h-1`) DO (
    SET "DB_NAME=%%d"
    REM The following lines trim trailing whitespace that sqlcmd sometimes adds
    FOR /F "tokens=* delims= " %%z IN ("!DB_NAME!") DO SET "DB_NAME=%%z"

    SET /A DB_COUNT+=1
    echo   [!DB_COUNT!] !DB_NAME!
    SET "DATABASE_!DB_COUNT!=!DB_NAME!"
)

IF !DB_COUNT! EQU 0 (
    echo No user databases found for this instance.
    GOTO :EOF
)
echo.

REM --- Step 4: Get User Input ---
:GET_CHOICE
SET "USER_CHOICE="
SET /P "USER_CHOICE=Enter the number for your database: "

REM Validate input
IF NOT DEFINED USER_CHOICE (GOTO GET_CHOICE)
IF !USER_CHOICE! GTR !DB_COUNT! (ECHO Invalid number. Please try again.& GOTO GET_CHOICE)
IF !USER_CHOICE! LSS 1 (ECHO Invalid number. Please try again.& GOTO GET_CHOICE)

REM --- Step 5: Generate and Display the Final Connection String ---
SET "SELECTED_DB=!DATABASE_%USER_CHOICE%!"

echo.
echo --------------------- FINAL CONNECTION STRING ---------------------
echo.
echo Here is your connection string. Please copy the entire line:
echo.
echo "Data Source=%SERVER_INSTANCE%;Initial Catalog=!SELECTED_DB!;Integrated Security=True;Connect Timeout=30;Encrypt=!ENCRYPT_VALUE!;Trust Server Certificate=!TRUST_CERT_VALUE!;Application Intent=ReadWrite;Multi Subnet Failover=False"
echo.
echo -------------------------------------------------------------------
GOTO :EOF